#include "../include/parser.h"

Parser::Parser(int argc, char *argv[])

{

    ArgCounter = argc;
    Argument = new string [ArgCounter];
    for (int n = 0; n < argc; n++) {
        for (int m = 0; argv[n][m] > 0; m++)
            if (argv[n][0] == '-')
                argv [n][m] = tolower (argv[n][m]);
        Argument[n] = argv[n];
    }
}

Parser::~Parser()
{
    delete [] Argument;
}

int Parser::Compare (const string &c, const string &c2)
{
    string::const_iterator p = c.begin();
    string::const_iterator p2 = c2.begin();

    while (p != c.end() && p2 != c.end()) {
        if (toupper(*p) != toupper(*p2))
            return (toupper (*p) < toupper (*p2))?-1:1;
        ++p;
        ++p2;
    };

    return (c2.size() == c.size()) ? 0 : (c.size() < c2.size()) ? -1 : 1;
}

int Parser::SearchString (const string &s)
{
    for (int n = 0; n < ArgCounter; n++)
        if (!Compare (s, Argument[n]))
            return n;

    return -1;
}


int Parser::Counter ()
{
    return ArgCounter;
}

const char* Parser::Arg (int Number)
{
    return Argument[Number].c_str();
}
